#ifndef ZEGO_DIGITAL_HUMAN_VIEW_H
#define ZEGO_DIGITAL_HUMAN_VIEW_H

#import <UIKit/UIKit.h>

//#import "ZegoFrameData.h"
#import <ZegoDigitalMobile/ZegoFrameData.h>

@interface ZegoPreviewView : UIView

@property(nonatomic, copy) void (^firstFrameCallback)(void);

- (void)drawFrame:(ZegoFrameData *)frameData;

- (void)updateWithImageBuffer:(void *)largeImage
                        width:(int)width
                       height:(int)height
                     subImage:(void *)subImage
                     subWidth:(int)subWidth
                    subHeight:(int)subHeight
                         rect:(CGRect)rect;

- (void)updateWithImageBuffer:(void *)largeImage
                        width:(int)width
                       height:(int)height
                     subImage:(void *)subImage
                     subWidth:(int)subWidth
                    subHeight:(int)subHeight
                         rect:(CGRect)rect
                 subBytesPerRow:(NSUInteger)subBytesPerRow;

- (void)stop;

@end

#endif // #ifndef ZEGO_DIGITAL_HUMAN_VIEW_H

