#ifndef ZEGO_DIGITAL_MOBILE_ERRORS_H
#define ZEGO_DIGITAL_MOBILE_ERRORS_H


// TODO: 暴露

#import <Foundation/Foundation.h>

// extern NSString *ERROR_DOMAIN;

/**
 * 数字人错误码
 */
typedef NS_ENUM(NSInteger, ZegoDigitalMobileError) {
    ZegoDigitalMobileErrorSuccess       = 0,                // 成功
    
    // 参数验证错误 (-200000 ~ -200009)
    ZegoDigitalMobileErrorInvalidParam  = -200000,          // 通用参数错误
    ZegoDigitalMobileErrorInvalidDigitalHumanId = -200001,  // 数字人ID为空或无效
    ZegoDigitalMobileErrorInvalidToken  = -200002,          // Token为空或无效
    ZegoDigitalMobileErrorInvalidUserId = -200003,          // 用户ID为空或无效
    ZegoDigitalMobileErrorInvalidUrl    = -200004,          // URL为空或无效
    
    // 网络相关错误 (-200010 ~ -200019)
    ZegoDigitalMobileErrorNetwork       = -200010,          // 通用网络错误
    ZegoDigitalMobileErrorTimeout       = -200011,          // 请求超时
    ZegoDigitalMobileErrorNetworkConnectionLost = -200012,  // 网络连接丢失
    ZegoDigitalMobileErrorCannotConnectToHost = -200013,    // 无法连接到主机
    ZegoDigitalMobileErrorNetworkRequestFailed = -200014,   // 网络请求失败
    
    // 资源加载错误 (-200020 ~ -200029)
    ZegoDigitalMobileErrorLoadResource  = -200020,          // 通用资源加载错误
    ZegoDigitalMobileErrorInvalidRenderInfo = -200021,      // 渲染信息数据无效
    ZegoDigitalMobileErrorDownloadFailed = -200022,         // 下载失败
    ZegoDigitalMobileErrorFileCopyFailed = -200023,         // 文件复制失败
    ZegoDigitalMobileErrorResourceExtractFailed = -200024,  // 资源解压失败
    ZegoDigitalMobileErrorMaterialDownloadFailed = -200025, // 素材包下载失败
    
    // 文件操作错误 (-200030 ~ -200039)
    ZegoDigitalMobileErrorFileOperation = -200030,          // 通用文件操作错误
    ZegoDigitalMobileErrorCacheDirNotFound = -200031,       // 获取缓存目录失败
    ZegoDigitalMobileErrorCacheDeleteFailed = -200032,      // 删除缓存目录失败
    
    // 内部操作错误 (-200040 ~ -200049)
    ZegoDigitalMobileErrorInternal      = -200040,          // 通用内部错误
    ZegoDigitalMobileErrorOperationCancelled = -200041,     // 操作已取消
    ZegoDigitalMobileErrorDuplicatedStart = -200042,        // 重复启动错误
    
    // 后台服务错误 (-200050 ~ -200059)
    ZegoDigitalMobileErrorBackend       = -200050,          // 通用后台错误
    ZegoDigitalMobileErrorBackendRequestFailed = -200051,   // 后台请求失败
    ZegoDigitalMobileErrorBackendResponseInvalid = -200052, // 后台响应无效
};

// 保留旧的错误码枚举，确保向后兼容
typedef NS_ENUM(NSInteger, ZegoDigtalMobileResult) {
    Success = 0,                 // 成功
    LoadResourceError = -200000, // 错误：加载资源错误
    BackendError = -200001       // 错误：后台错误
};

#endif // #ifndef ZEGO_DIGITAL_MOBILE_ERRORS_H
