//
//  ZegoDigitalHumanResourceLoadInfo.h
//  ZegoDigitalMobile
//
//  Created by zego on 2025/7/13.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 预加载进度阶段
typedef NS_ENUM(NSInteger, ZegoDigitalHumanResourceProgressStage) {
    ZegoDigitalHumanResourceProgressStageDownloading = 0,
    ZegoDigitalHumanResourceProgressStageUnzipping = 1,
    ZegoDigitalHumanResourceProgressStageExtracting = 2
};

/// 预加载状态
typedef NS_ENUM(NSInteger, ZegoDigitalHumanResourceLoadState) {
    ZegoDigitalHumanResourceLoadStateIdle = 0,        // 空闲状态
    ZegoDigitalHumanResourceLoadStateLoading = 1,     // 正在加载
    ZegoDigitalHumanResourceLoadStateLoaded = 2,      // 已加载完成
    ZegoDigitalHumanResourceLoadStateFailed = 3       // 加载失败
};

@protocol ZegoDigitalHumanResourceDelegate <NSObject>

@optional

/// 预加载成功回调
/// @param digitalHumanId 数字人ID
- (void)onPreloadSuccess:(NSString *)digitalHumanId;

/// 预加载失败回调
/// @param digitalHumanId 数字人ID
/// @param errorCode 错误码
/// @param errorMessage 错误信息
- (void)onPreloadFailed:(NSString *)digitalHumanId
              errorCode:(NSInteger)errorCode
           errorMessage:(NSString *)errorMessage;

/// 预加载进度回调
/// @param digitalHumanId 数字人ID
/// @param progress 总进度（0-100）
/// @param stage 当前阶段
/// @param stageProgress 当前阶段进度（0-100）
- (void)onPreloadProgress:(NSString *)digitalHumanId
                 progress:(float)progress;

@end



/// 资源加载信息（内存中使用）
@interface ZegoDigitalHumanResourceLoadInfo : NSObject
@property (nonatomic, assign) ZegoDigitalHumanResourceLoadState state;
@property (nonatomic, weak) id<ZegoDigitalHumanResourceDelegate> delegate;
@property (nonatomic, copy) NSString *digitalHumanId;
//@property (nonatomic, strong) id resourceManager;
@property (nonatomic, copy) NSString *packageUrl;
@property (nonatomic, copy) NSString *localFilePath;
@property (nonatomic, assign) float currentProgress;
@property (nonatomic, assign) ZegoDigitalHumanResourceProgressStage currentStage;
@property (nonatomic, copy) NSString *resourceID;  // 新增：资源ID
@end




NS_ASSUME_NONNULL_END
