#ifndef ZegoDigitalHumanResource_h
#define ZegoDigitalHumanResource_h

#import <Foundation/Foundation.h>
#import <ZegoDigitalMobile/ZegoDigitalHumanAuth.h>
#import <ZegoDigitalMobile/ZegoDigitalHumanResourceLoadInfo.h>
#import <ZegoDigitalMobile/IsLoadedDelegate.h>

NS_ASSUME_NONNULL_BEGIN

/// 数字人资源预加载管理类
@interface ZegoDigitalHumanResource : NSObject

/// 单例实例
+ (instancetype)sharedInstance;

/// 预加载数字人资源
/// @param digitalHumanId 数字人ID
/// @param delegate 回调代理
- (void)preloadWithAuth:(ZegoDigitalHumanAuth*)auth
         digitalHumanId:(NSString *)digitalHumanId
               delegate:(id<ZegoDigitalHumanResourceDelegate>)delegate;

/// 检查指定数字人资源是否已加载
/// @param auth 鉴权信息
/// @param digitalHumanId 数字人ID
/// @param delegate 回调
- (void)isLoadedWithAuth:(ZegoDigitalHumanAuth*)auth
          digitalHumanId:(NSString *)digitalHumanId
                delegate:(id<IsLoadedDelegate>)delegate;

- (void)unLoad:(NSString *)digitalHumanId;



@end

NS_ASSUME_NONNULL_END 

#endif // #ifndef ZegoDigitalHumanResource_h
