#ifndef IsLoadedDelegate_h
#define IsLoadedDelegate_h

#import <Foundation/Foundation.h>

@protocol IsLoadedDelegate <NSObject>

@optional

/// 接口执行成功回调
/// @param digitalHumanID 被查询的数字人 ID
/// @param isLoaded 查询结果
- (void)onIsLoadedSucceed:(NSString *)digitalHumanID isLoaded:(BOOL)isLoaded;

/// 接口执行失败回调
/// @param digitalHumanID 被查询的数字人 ID
/// @param code 错误码
/// @param msg 错误信息
- (void)onIsLoadedError:(NSString *)digitalHumanID code:(int)code msg:(NSString*)msg;

@end

#endif // #ifndef IsLoadedDelegate_h
